* Encoding: UTF-8.

*===================================================================================*
* TTULO DE LA SINTAXIS:*
* Clculo: TASA DE VEHCULOS MATRICULADOS POR CADA MIL HABITANTES*
* OPERACIN ESTADSTICA:*
* Anuario de Transporte 2018 - Vehculos Motorizados Matriculados*
*DIRECCIN TCNICA RESPONSABLE:*
* Direccin de Estadsticas Econmicas (DECON)*
* ENTIDAD EJECUTORA:*
* Instituto Nacional de Estadstica y Censos (INEC)*
*===================================================================================*
* Fecha de elaboracin:        11 de Diciembre del 2018*
* Fecha ltima modificacin:   05 de Septiembre del 2019*
*===================================================================================*
* Elaborado por:*
* Unidad de Gestin de Estadsticas Estructurales (GESE)*.
* Franklin Tenesaca N.
* Gabriela Hidalgo.

*Instrucciones:.
*1.- Descarga la base de datos de Vehculos Matriculados "2018_vehiculos_matriculados_bdd" en formato SPSS de la pgina web del INEC (http://www.ecuadorencifras.gob.ec//transporte/).
*2.- Guardar y abrir la base de datos "2018_vehiculos_matriculados_bdd".

DATASET NAME VEHICULOS_MATRICULADOS.
DATASET COPY VEHICULOS_MATRICULADOS.
DATASET ACTIVATE VEHICULOS_MATRICULADOS.

**********************************************************************************************************************.
**************TASA DE VEHCULOS MATRICULADOS POR CADA MIL HABITANTES*********************.
**********************************************************************************************************************.

COMPUTE VEHICULOS=1.
FORMATS VEHICULOS (F10.0).
VARIABLE LABELS VEHICULOS 'Nmero de vehculos'.
EXECUTE.

***Agregando la base de datos segn provincia**.

DATASET DECLARE VEHICULOS.
AGGREGATE
  /outfile='VEHICULOS'
  /break=PROVINCIA
  /VEHICULOS=SUM(VEHICULOS).

DATASET ACTIVATE VEHICULOS.

VARIABLE LABELS VEHICULOS 'Nmero de vehculos motorizados matriculados'.
FORMATS VEHICULOS (F10.0).
VARIABLE LEVEL VEHICULOS (SCALE).
EXECUTE.

IF (PROVINCIA=1) POBLACION=853070.
IF (PROVINCIA=2) POBLACION=206771.
IF (PROVINCIA=3) POBLACION=272236.
IF (PROVINCIA=4) POBLACION=184136.
IF (PROVINCIA=5) POBLACION=476428.
IF (PROVINCIA=6) POBLACION=515417.
IF (PROVINCIA=7) POBLACION=698545.
IF (PROVINCIA=8) POBLACION=626626.
IF (PROVINCIA=9) POBLACION=4267893. 
IF (PROVINCIA=10) POBLACION=463957.
IF (PROVINCIA=11) POBLACION=511184.
IF (PROVINCIA=12) POBLACION=899632.
IF (PROVINCIA=13) POBLACION=1537090.
IF (PROVINCIA=14) POBLACION=188028.
IF (PROVINCIA=15) POBLACION=128252.
IF (PROVINCIA=16) POBLACION=108365.
IF (PROVINCIA=17) POBLACION=3116111.
IF (PROVINCIA=18) POBLACION=577551.
IF (PROVINCIA=19) POBLACION=115368.
IF (PROVINCIA=20) POBLACION=31600.
IF (PROVINCIA=21) POBLACION=220483.
IF (PROVINCIA=22) POBLACION=157520.
IF (PROVINCIA=23) POBLACION=442788.
IF (PROVINCIA=24) POBLACION=384102.
IF (PROVINCIA=99) POBLACION=40255.
EXECUTE.

VARIABLE LABELS POBLACION 'Proyeccin poblacional'.
FORMATS POBLACION (F10.0).
VARIABLE LEVEL POBLACION (SCALE).
EXECUTE.

COMPUTE TMV= (VEHICULOS/(POBLACION/1000)).
FORMATS TMV (F5.0).
VARIABLE LABELS TMV 'Tasa de vehculos matriculados por cada mil habitantes'.
EXECUTE.

SORT CASES BY PROVINCIA (A).


***CUADRO N 15***.

****POR PROVINCIAS****.

TABLES
/OBSERVATION= VEHICULOS POBLACION TMV
/TABLE=PROVINCIA BY VEHICULOS + POBLACION + TMV
/STATISTICS=SUM
/TITLE='CUADRO N 15'
            'VEHCULOS MATRICULADOS POR CADA 1000 HABITANTES, ao 2018'
            'POR PROVINCIAS'
            '(Nmero)'
/CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
                 'Fuente: ANT - Agencia Nacional de Trnsito- 2018' 
                 'INEC - Proyecciones Poblacionales 2018'. 	


DATASET ACTIVATE VEHICULOS_MATRICULADOS.
DATASET CLOSE VEHICULOS.







